
* File sacalcspec1.inc

$ONTEXT
This calc file forms a blend of the specified subset of wastes (specified in w\
astcomp.prn) and performs a single optimization with the blended waste.
Each waste to be blended is a column in the table (matrix) WasteComps).
$OFFTEXT





* SA Block

Parameters T0, Tf, Nmax, alpha, Objfunc, delta,tankno1, tankno2, optim(Blends, Waste , Position), previous;
Scalars T,N, a,b,e,d;
Set Calcul(Blends, Comp);
Scalars b1i1,b1i3,b2i1,b2i3;
T0 = 100 ;
alpha = 0.95 ;
Tf = 0.01 ;
T = 100 ;
Nmax = 100 ;
Objfunc = 1.803186E+7 ;
PARAMETER count  /0/;
Previous = 0;

while(((T ge Tf) and (count <= 10)),
    N = 0;
    for(N = 0 to Nmax,
        a = uniform(0,1);
        if (a <= (1/3),
            b1i1 = 1;
            b2i1 = 2;
        elseif ((a > (1/3))and (a <= (2/3))),
            b1i1 = 2;
            b2i1 = 3;
        else
            b1i1 = 3;
            b2i1 = 1;
           );
        b = uniform(0,1);
        if (b <= (1/7),
            b1i3 = 1;
        elseif ((b > (1/7)) and (b <= (2/7))),
            b1i3 = 2;
        elseif ((b > (2/7)) and (b <= (3/7))),
            b1i3 = 3;
        elseif ((b > (3/7)) and (b <= (4/7))),
            b1i3 = 4;
        elseif ((b > (4/7)) and (b <= (5/7))),
            b1i3 = 5;
        elseif ((b > (5/7)) and (b <= (6/7))),
            b1i3 = 6;
        else
            b1i3 = 7;
           );
        e = uniform(0,1);
        if (e <= (1/7),
            b2i3 = 1;
        elseif ((e > (1/7)) and (e <= (2/7))),
            b2i3 = 2;
        elseif ((e > (2/7)) and (e <= (3/7))),
            b2i3 = 3;
        elseif ((e > (3/7)) and (e <= (4/7))),
            b2i3 = 4;
        elseif ((e > (4/7)) and (e <= (5/7))),
            b2i3 = 5;
        elseif ((e > (5/7)) and (e <= (6/7))),
            b2i3 = 6;
        else
            b2i3 = 7;
           );
*        display b2i1,b1i1,b1i3,b2i3,y.l;


* Swapping

        tankno1 = sum(blends,sum(position,sum(waste, ord(waste)*y.l(Blends, Waste , Position)$
                                                     ((ord(Blends)=b1i1)and (ord(Position) = b1i3)))));
        tankno2 = sum(blends,sum(position,sum(waste, ord(waste)*y.l(Blends, Waste , Position)$
                                                     ((ord(Blends)=b2i1)and (ord(Position) = b2i3)))));
        Display tankno1, tankno2, y.l;
        y.fx(Blends, Waste , Position)$((ord(Blends)=b2i1)and (ord(Waste)=tankno2) and (ord(Position) = b2i3)) = 0;
        y.fx(Blends, Waste , Position)$((ord(Blends)=b1i1)and (ord(Waste)=tankno1) and (ord(Position) = b1i3)) = 0;
        y.fx(Blends, Waste , Position)$((ord(Blends)=b2i1)and (ord(Waste)=tankno1) and (ord(Position) = b2i3)) = 1;
        y.fx(Blends, Waste , Position)$((ord(Blends)=b1i1)and (ord(Waste)=tankno2) and (ord(Position) = b1i3)) = 1;
*        Display b2i1,b1i1,b1i3,b2i3,y.l;

        z(Blends, Waste,Position) = y.l(Blends, Waste, Position);

        Massoxide(Blends) = SUM(Waste, sum(position,z(Blends, Waste,Position)) * WasteComps('OxideMass', Waste));

        Solve Wasteoptim minimizing Totalfrit using NLP;

        delta = Totalfrit.L - Objfunc;
        d = uniform(0,1);   display T,delta;
        if (((delta <= 0) or (d <= (exp(-delta*(10**(-6))/T)))),
            Objfunc = Totalfrit.L;
            optim(Blends, Waste, Position) = y.l(Blends, Waste, Position);
           );
        if (Objfunc = Previous,
            count = count + 1;
           );
        previous = objfunc;
       );
    T = alpha * T ;
    Display T;
    );





CanMass   = MaxLogMass;
NumCans.L(Blends)   = MassOxide(Blends)/TMWG.L(Blends);
Viscosity(Blends) = EXP(SUM(I,AV(I)*FG.L(Blends,I)) + SUM((I,J),BV(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));
ElectCond(Blends) = EXP(SUM(I,AE(I)*FG.L(Blends,I)) + SUM((I,J),BE(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));
BorDissPCT(Blends)= EXP(SUM(I,ADPB(I)*FG.L(Blends,I)) + SUM((I,J),BDPB(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));
BorDissMCC(Blends)= EXP(SUM(I,ADMB(I)*FG.L(Blends,I)) + SUM((I,J),BDMB(I,J)*FG.L(Blends,I)*FG.L(Blends,J)));
Frit.L(Blends)    = Numcans.L(Blends)*TMFG.L(Blends);

  Display Totalfrit.L;
  Display Objfunc;
  Display optim;
  Display Frit.L;
  Display WasteFrac.L;
  Display MassOxide, NumCans.L;
  Display TMWG.L, TMFG.L;
  Display Viscosity, ElectCond, BorDissPCT, BorDissMCC;
  Display FW.L, FF.L, FG.L ;